#include <windows.h>
#include <gl/gl.h>
/******************************************************************************
 * rendertexture.cpp - Gestion de la texture de rendu                         *
 ******************************************************************************
 * Projet       : Code(R) - Sphere                                            *
 * Auteur       : Arnaud Storq (http://norecess.planet-d.net)/Posse-Press 2004*
 ******************************************************************************/
#include "main.h"
#include "rendertexture.h"
#include "math.h"

//---------------------------------------------------------------------------- VARIABLES LOCALES
static unsigned int m_textureOpenGL;            // identifiant OpenGL de la texture

//---------------------------------------------------------------------------- INITIALISATION
void renderTextureInitialiser( )
{
    // Allouer un espace mmoire de la taille de la texture de rendu
    int *buffer = new int[ RESOLUTION_RENDERTEXTURE_LARGEUR * RESOLUTION_RENDERTEXTURE_HAUTEUR ];
            
    // Demander  OpenGL un nouvel identifiant de texture
    glGenTextures( 1, &m_textureOpenGL );

    // Selectionner la nouvelle texture
    glBindTexture( GL_TEXTURE_2D, m_textureOpenGL );

    // Forcer l'affichage bilineaire sur la texture
    glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR );    
	glTexParameteri( GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR );

    // On doit indiquer  OpenGL la taille de la texture
    // GL_RGB signifie que la texture est au format RGBA 32 bits (8 bits par composantes (R=rouge, G=vert, B=bleu) plus 8 bits d'alpha)
    // On a pas effac le contenu de "buffer" parce qu'il sera ecras  chaque nouveau rendu de la sphere !
    glTexImage2D( GL_TEXTURE_2D, 0, 4, RESOLUTION_RENDERTEXTURE_LARGEUR, RESOLUTION_RENDERTEXTURE_HAUTEUR, 0, GL_RGBA, GL_UNSIGNED_BYTE, buffer );

    // On peut ds  prsent effacer la texture de la mmoire centrale..
    delete [] buffer;
}

//---------------------------------------------------------------------------- AFFICHAGE
void renderTextureAfficher( )
{
    // Dimensionne l'ecran OpenGL  la taille de la fenetre OpenGL
    // du coup, glVertex3f(-1.0f, -1.0f, -1.0f) sera plac en haut a gauche
    // et glVertex3f(1.0f, -.0f, -1.0f) sera plac en bas a droite !
    glViewport( 0, 0, RESOLUTION_LARGEUR, RESOLUTION_HAUTEUR);
               
    // Selectionne la texture de rendu
    glBindTexture( GL_TEXTURE_2D, m_textureOpenGL );
        
    // Ecraser le contenu de la texture de rendu par ce qui a deja t dessin  l'ecran !
    // C'est ici que reside tout le secret de cet effet !
    glCopyTexImage2D( GL_TEXTURE_2D, 0, GL_RGBA, 0, 0, RESOLUTION_RENDERTEXTURE_LARGEUR, RESOLUTION_RENDERTEXTURE_HAUTEUR, 0 );
        
    // A present, on peut effacer le contenu de l'ecran, puis afficher successivement avec des
    // rectangles le contenu de la texture de rendu, que l'on va superposer en activant de la
    // transparence additive !! ....
    
    // Effacer uniquement le contenu de l'ecran (pas besoin d'effacer le Z-Buffer)
    glClear ( GL_COLOR_BUFFER_BIT );
    
    // Comme on a pas besoin du Z-Buffer (puisque pour afficher des quadrangles
    // il n'y aura pas de tri en Z), on le desactive..
    glDisable( GL_DEPTH_TEST );
                    
    // Active la transparence
    glEnable( GL_BLEND );
    
    // Indique que la transparence sera de l'additif
    // Cela veut dire, les composantes du pixel de la texture lors du rendu sera additionn
    // au pixel  l'ecran. Si ce dernier depasse 1, alors il est ramen  1, on dit que la valeur est "clampe"
    glBlendFunc( GL_SRC_ALPHA, GL_ONE );
                        
    // On veut afficher des quadrangles..
    glBegin ( GL_QUADS );
    
    // Afficher les differents quadrangles, les uns sur les autres avec un leger increment de dplacement..
    for ( float zoom = ZOOM_DEBUT; zoom < ZOOM_FIN; zoom += ZOOM_INCREMENT )
    {    
        // Coin haut-gauche..        
        glTexCoord2f( 0.0f, 0.0f );
        glVertex3f( -zoom, -zoom, -1.0f );

        // Coin haut-droit..        
        glTexCoord2f( 0.0f, 1.0f );
        glVertex3f( zoom, -zoom, -1.0f );

        // Coin bas-droit..        
        glTexCoord2f( 1.0f, 1.0f );
        glVertex3f( zoom, zoom, -1.0f );

        // Coin bas-gauche..        
        glTexCoord2f( 1.0f, 0.0f );
        glVertex3f( -zoom, zoom, -1.0f );
    }
    
    // Arrete l'affichage des quadrangles
    glEnd();
    
    // Desactive la transparence
    glDisable( GL_BLEND );    
}

//---------------------------------------------------------------------------- DESTRUCTION
void renderTextureDetruire()
{
    // Indique  OpenGL d'effacer la texture de la carte 3D, plus ses initilisations internes
    glDeleteTextures(1, &m_textureOpenGL);
}
